#!/bin/ksh
# @(#)pkg_resolve.sh	1.4 07/03/01
# Copyright 2007 Sun Microsystems, Inc. All rights reserved.

# General pkg resolver script for both the tzupdater (1.4+) and tzupdater131 tool.
# Run with full path to java, after the tzupdater tool, to resynchronize the Solaris
# pkg database

# e.g. ./pkg_resolve.sh /usr/jdk/instances/jdk1.5.0_06/bin/java
#
# For 1.4+ All files in the jre/lib/zi directory are removed from pkg database,
# all files presently in that location are added.
# For 1.3.1, the rt.jar meta-data is updated within the pkg database.
#
# For 1.4 and later JREs, we call the FilePkgUpdater function to iterate through
# the various jre/lib/zi files and update the pkgDB with the new attributes
# For 1.3.1, we simply update the pkgDB with the new rt.jar attributes. (FilePkgUpdater131 function)
#
# exit 0 if no update required
# exit 1 if error encountered


function FilePkgUpdater  {
TEMP=/tmp/fix.pre.LIST.$$

if [ x$PKG == "x" ]
then
        echo $JAVA not directly found in contents file, no package resolution performed.
        echo "(May not be in PKG form, not an absolute path, or is a symlink.)"
	exit 0
fi

# Only attempt pkg updates as root:
set `/usr/bin/id`
if [ $1 != "uid=0(root)" ]; then
        echo "Not running as root: pkg refresh not attempted."
        exit 1
fi


BASEDIR=`egrep "$PKG$" /var/sadm/install/contents | grep "zi " | nawk '{print $1}'`

if [ x$BASEDIR == "x" ]
then
	echo Cannot find base directory in /var/sadm/install/contents
	exit 1
fi

echo Updating package $PKG with timezone base directory $BASEDIR
echo "(update time is variable, but  can take ~15minutes.)"
#
# removef the zi files in the package:
#
# find all in & under zi directory which is also in the contents file:
# ..and removef it from PKG

find $BASEDIR -exec grep {} /var/sadm/install/contents \; | grep $PKG | nawk '{print $1}' > $TEMP

for i in `cat $TEMP`
do
	echo $i
	removef $PKG $i
	if [ $? -ne 0 ]
	then
       		echo ERROR during: removef $PKG $i
		rm $TEMP
        	exit 1
	fi
done

removef -f $PKG 
        if [ $? -ne 0 ]
        then
                echo ERROR during: removef $PKG
                rm $TEMP
                exit 1
        fi

rm $TEMP


# Phase 2: add current zi files to pkg directory
# find in the zi directory, 
# installf the zi-related files in the package.

# find directories:

find $BASEDIR -type d > $TEMP
for i in `cat $TEMP`
do
	echo $i
	installf $PKG $i d 755 root bin
        if [ $? -ne 0 ]
        then
                echo ERROR during: installf $PKG $i d 755 root bin
                rm $TEMP
                exit 1
        fi
done

# find files:

find $BASEDIR -type f > $TEMP
for i in `cat $TEMP`
do
	installf $PKG $i v
        if [ $? -ne 0 ]
        then
                echo ERROR during: installf $PKG $i v
                rm $TEMP
                exit 1
        fi
done

installf -f $PKG
if [ $? -ne 0 ]
then
        echo ERROR during: installf -f $PKG 
        rm $TEMP
        exit 1
fi

rm $TEMP

echo "Completed resolving Solaris package information."
}

function FilePkgUpdater131  {
# find package name from java path
# 1.3.1 Java appears in contents file as:
#
#   # grep "/usr/j2se/bin/java=" /var/sadm/install/contents
#   /usr/j2se/bin/java=.java_wrapper s none SUNWj3rt
#
#   # grep "/usr/j2se/jre/bin/java=" /var/sadm/install/contents
#   /usr/j2se/jre/bin/java=.java_wrapper s none SUNWj3rt

if [ x$PKG == "x" ]
then
        echo $JAVA not directly found in contents file, no package resolution performed.
        echo "(May not be in PKG form, not an absolute path, or is a symlink.)"
        exit 0
fi

# Only attempt pkg updates as root:
set `/usr/bin/id`
if [ $1 != "uid=0(root)" ]; then
        echo "Not running as root: pkg refresh not attempted."
        exit 1
fi

RTJAR=`egrep "$PKG$" /var/sadm/install/contents | grep "jre/lib.rt.jar" | nawk '{print $1}'`

if [ x$RTJAR == "x" ]
then
        echo Cannot find rt.jar in /var/sadm/install/contents
        exit 1
fi

echo Updating package $PKG with new $RTJAR

#
# removef rt.jar
#
echo $i
removef $PKG $RTJAR

if [ $? -ne 0 ]
then
        echo ERROR during: removef $PKG $RTJAR
        exit 1
fi


# Phase 2: add current rt.jar

installf $PKG $RTJAR v
if [ $? -ne 0 ]
then
        echo ERROR during: installf $PKG $RTJAR v
        exit 1
fi

installf -f $PKG
if [ $? -ne 0 ]
then
        echo ERROR during: installf -f $PKG
        exit 1
fi


echo "Completed resolving Solaris package information."

}

JAVA=$1
PATH=/bin/:/usr/bin:/usr/sbin


if [ x$JAVA == "x" ]
then
	echo "Usage: script.sh <path to java>"
	exit 1
fi

if [[ ! -a $JAVA ]]
then
	echo Non-existent java path: $JAVA
	exit 1
fi

# determine Java version so we know what update approach to take.
version_string=`$JAVA -fullversion 2>&1 | awk '{print $NF}'`
jdk_release=`echo ${version_string} | sed 's/"//g' | awk 'BEGIN{FS="-"}{print $1}'`
jdk_release=`echo ${jdk_release} | awk 'BEGIN{FS="."}{print $2}'`

if [[ $jdk_release -eq 3 ]];then
    PKG=`grep "^$JAVA=" /var/sadm/install/contents | nawk '{print $4}' | sed s/\*//`
elif [[ $jdk_release -gt 3 ]];then
    # find package name from java path
    PKG=`grep "^$JAVA " /var/sadm/install/contents | nawk '{print $10}' | sed s/\*//`
fi

# Call the update functions - 1.4 and above use FilePkgUpdater
# For 1.3.1 JDKs we always update with FilePkgUpdater131 function.

if [[ $jdk_release -eq 3 ]];then
    FilePkgUpdater131
elif [[ $jdk_release -gt 3 ]];then
    FilePkgUpdater
fi


