/*
 * Decompiled with CFR 0.152.
 */
package sybase.jdbc.sqlanywhere;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import sybase.jdbc.sqlanywhere.IIPreparedStatement;
import sybase.jdbc.sqlanywhere.IResource;

class IICallableStatement
extends IIPreparedStatement
implements CallableStatement {
    private ArrayList outParamTypes = new ArrayList();

    private IICallableStatement(long l) {
        super(l);
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native BigDecimal getBigDecimal(int var1, int var2) throws SQLException;

    public native BigDecimal getBigDecimal(int var1) throws SQLException;

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native boolean getBoolean(int var1) throws SQLException;

    public native byte getByte(int var1) throws SQLException;

    public native byte[] getBytes(int var1) throws SQLException;

    public Clob getClob(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native Date getDate(int var1) throws SQLException;

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        return new Date(calendar.get(1) - 1900, calendar.get(2), calendar.get(5));
    }

    public native double getDouble(int var1) throws SQLException;

    public native float getFloat(int var1) throws SQLException;

    public native int getInt(int var1) throws SQLException;

    public native long getLong(int var1) throws SQLException;

    public Object getObject(int n) throws SQLException {
        switch (this.getParamType(n)) {
            case -7: {
                boolean bl = this.getBoolean(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Boolean(bl);
            }
            case -6: {
                byte by = this.getByte(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Byte(by);
            }
            case 4: 
            case 5: {
                int n2 = this.getInt(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Integer(n2);
            }
            case -5: {
                long l = this.getLong(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Long(l);
            }
            case 6: 
            case 7: {
                float f = this.getFloat(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Float(f);
            }
            case 8: {
                double d = this.getDouble(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
        }
        throw new SQLException(IResource.getString("CANNOT_MAP_CLASS", String.valueOf(n)));
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native short getShort(int var1) throws SQLException;

    public native String getString(int var1) throws SQLException;

    public native Time getTime(int var1) throws SQLException;

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        calendar.setTime(time);
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public native Timestamp getTimestamp(int var1) throws SQLException;

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        calendar.setTime(timestamp);
        calendar.set(14, (int)((double)timestamp.getNanos() / 1000000.0 + 0.5));
        return new Timestamp(calendar.get(1) - 1900, calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.nativeRegisterOutParameter(n, n2);
        this.setParamType(n, n2);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.nativeRegisterOutParameter(n, n2, n3);
        this.setParamType(n, n2);
    }

    public native void nativeRegisterOutParameter(int var1, int var2) throws SQLException;

    public native void nativeRegisterOutParameter(int var1, int var2, int var3) throws SQLException;

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native boolean wasNull() throws SQLException;

    public void setParamType(int n, int n2) {
        this.outParamTypes.ensureCapacity(n);
        for (int i = this.outParamTypes.size(); i < n; ++i) {
            this.outParamTypes.add(i, null);
        }
        this.outParamTypes.set(n - 1, new Integer(n2));
    }

    public int getParamType(int n) throws SQLException {
        return (Integer)this.outParamTypes.get(n - 1);
    }

    public native void release();

    public void registerOutParameter(String string, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void setNull(String string, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setShort(String string, short s) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setInt(String string, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setLong(String string, long l) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setString(String string, String string2) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public String getString(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public short getShort(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public int getInt(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public long getLong(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public float getFloat(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public double getDouble(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Date getDate(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Time getTime(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Object getObject(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException(IResource.getString("NAMED_PARAMETERS"));
    }
}

