/*
 * Decompiled with CFR 0.152.
 */
package sybase.jdbc.sqlanywhere;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import sybase.jdbc.sqlanywhere.IConnection;
import sybase.jdbc.sqlanywhere.IResource;

public final class IDriver
implements Driver {
    private static final int PREFIX_JOIN_CONN = 1000;
    private static final int PREFIX_NEW_CONN = 2000;
    private static final int PREFIX_NEW_CONN2 = 0;
    private static final String LONG_HEX_PARM_START = ":0x";
    private static final String[] PROTOCOL_PREFIX;
    private static SQLException driverInitException;
    private static UnsatisfiedLinkError linkError;
    private static Class resource_class;
    private static final String dll_1 = "dbjdbc11";
    private static final String dll_2 = "dbjdbc11";
    static /* synthetic */ Class class$sybase$jdbc$sqlanywhere$IResource;

    private static UnsatisfiedLinkError try_load(String string, String string2, String string3, String string4) {
        block25: {
            try {
                if (string3 == null) {
                    System.loadLibrary(string);
                } else {
                    System.load(string3 + string4 + string + ".dll");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    if (string3 == null) {
                        System.loadLibrary(string2);
                    } else {
                        System.load(string3 + string4 + string2 + ".dll");
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    if (string3 != null) {
                        return unsatisfiedLinkError;
                    }
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = unsatisfiedLinkError.toString();
                    String string9 = System.mapLibraryName(string);
                    int n = string8.indexOf("lib64/" + string9);
                    if (n != -1) {
                        string5 = "lib64/";
                        string6 = "lib32/";
                        string7 = "/";
                    }
                    if (n == -1 && (n = string8.indexOf("lib32/" + string9)) != -1) {
                        string5 = "lib32/";
                        string6 = "lib64/";
                        string7 = "/";
                    }
                    if (n == -1 && (n = string8.indexOf("bin32\\" + string9)) != -1) {
                        string5 = "bin32\\";
                        string6 = "bin64\\";
                        string7 = "\\";
                    }
                    if (n == -1 && (n = string8.indexOf("Bin32\\" + string9)) != -1) {
                        string5 = "Bin32\\";
                        string6 = "Bin64\\";
                        string7 = "\\";
                    }
                    if (n == -1 && (n = string8.indexOf("bin64\\" + string9)) != -1) {
                        string5 = "bin64\\";
                        string6 = "bin32\\";
                        string7 = "\\";
                    }
                    if (n == -1 && (n = string8.indexOf("Bin64\\" + string9)) != -1) {
                        string5 = "Bin64\\";
                        string6 = "Bin32\\";
                        string7 = "\\";
                    }
                    if (n == -1) {
                        if (!IDriver.loadFromPath(string)) {
                            return unsatisfiedLinkError;
                        }
                        return null;
                    }
                    int n2 = string8.indexOf(string7);
                    n2 = n2 == -1 ? string8.lastIndexOf(" ", n) : string8.lastIndexOf(" ", n2);
                    if (n2 == -1) {
                        if (!IDriver.loadFromPath(string)) {
                            return unsatisfiedLinkError;
                        }
                        return null;
                    }
                    n = (string8 = string8.substring(n2 + 1)).indexOf(58, 2);
                    if (n == -1) {
                        if (!IDriver.loadFromPath(string)) {
                            return unsatisfiedLinkError;
                        }
                        return null;
                    }
                    String string10 = string8.substring(0, n);
                    if ((n = string10.indexOf(string5 + string9)) == -1) {
                        if (!IDriver.loadFromPath(string)) {
                            return unsatisfiedLinkError;
                        }
                        return null;
                    }
                    string10 = string10.substring(0, n);
                    string10 = string10 + string6 + string9;
                    try {
                        System.load(string10);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                        if (IDriver.loadFromPath(string)) break block25;
                        return unsatisfiedLinkError;
                    }
                }
            }
        }
        return null;
    }

    private static boolean loadFromPath(String string) {
        String string2 = System.getProperty("java.library.path");
        String string3 = System.getProperty("path.separator");
        String string4 = System.getProperty("file.separator");
        string = System.mapLibraryName(string);
        int n = 0;
        int n2 = string2.indexOf(string3, n);
        while (n2 != -1) {
            String string5 = string2.substring(n, n2);
            String string6 = string5 + string4 + string;
            boolean bl = false;
            try {
                System.load(string6);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = true;
            }
            if (!bl) {
                return true;
            }
            n = n2 + 1;
            n2 = string2.indexOf(string3, n);
        }
        return false;
    }

    public static void throwIfDriverInitFailed() throws SQLException, UnsatisfiedLinkError {
        if (linkError != null) {
            throw linkError;
        }
        int n = IDriver.getNativeLibraryMajorVersion();
        if (n != 3) {
            throw new SQLException(IResource.getString("MAJOR_VERSION_MISMATCH", String.valueOf(3), String.valueOf(n)));
        }
        if (driverInitException != null) {
            throw driverInitException;
        }
    }

    private int protocolNumber(String string) {
        for (int i = 0; i < PROTOCOL_PREFIX.length; ++i) {
            if (!string.startsWith(PROTOCOL_PREFIX[i])) continue;
            return i;
        }
        return -1;
    }

    private long extractLongParm(String string, int n) throws SQLException {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < n; ++n2) {
            if ((n3 = string.indexOf(LONG_HEX_PARM_START, n3 + 1)) != -1) continue;
            return 0L;
        }
        n2 = n3 + LONG_HEX_PARM_START.length();
        int n4 = string.indexOf(LONG_HEX_PARM_START, n2);
        if (n4 < 0) {
            n4 = string.length();
        }
        String string2 = string.substring(n2, n4);
        try {
            BigInteger bigInteger = new BigInteger(string2, 16);
            long l = bigInteger.longValue();
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(IResource.getString("INVALID_HDBC", string));
        }
    }

    public static native int getNativeLibraryMajorVersion();

    public static native int getNativeLibraryMinorVersion();

    private static native IConnection joinODBCConnection(long var0, long var2, long var4, int var6) throws SQLException;

    private static native IConnection makeODBCConnection(String var0, String var1, int var2) throws SQLException;

    private static native void initEnv(int var0, boolean var1);

    public static native void finiEnv();

    public boolean acceptsURL(String string) {
        return this.protocolNumber(string) >= 0;
    }

    public Connection connect(String string, Properties properties) throws SQLException, UnsatisfiedLinkError {
        Object object;
        IDriver.throwIfDriverInitFailed();
        int n = this.protocolNumber(string);
        if (n == 2000 || n == 0) {
            object = string.substring(0, PROTOCOL_PREFIX[n].length());
            boolean bl = false;
            object = string.substring(PROTOCOL_PREFIX[n].length());
            int n2 = ((String)object).indexOf(61);
            if (n2 == -1) {
                bl = true;
            } else {
                int n3 = ((String)object).indexOf(59);
                if (n3 != -1 && n3 < n2) {
                    bl = true;
                }
            }
            if (bl) {
                string = PROTOCOL_PREFIX[n] + "dsn=" + (String)object;
            }
        }
        object = null;
        switch (n) {
            case -1: {
                return null;
            }
            case 1000: {
                long l = this.extractLongParm(string, 1);
                if (l == 0L) {
                    return null;
                }
                long l2 = this.extractLongParm(string, 2);
                long l3 = this.extractLongParm(string, 3);
                object = IDriver.joinODBCConnection(l, l2, l3, 2472);
                break;
            }
            case 0: 
            case 2000: {
                String string2 = string.substring(PROTOCOL_PREFIX[n].length());
                if (properties != null) {
                    Object object2 = properties.get("user");
                    Object object3 = properties.get("password");
                    if (object2 != null) {
                        string2 = string2 + ";uid=" + object2.toString();
                    }
                    if (object3 != null) {
                        string2 = string2 + ";pwd=" + object3.toString();
                    }
                }
                object = IDriver.makeODBCConnection(string2, string, 2472);
                break;
            }
        }
        ((IConnection)object).setAttributes(properties);
        return object;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return null;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static Date calendarizeTo(Date date, Calendar calendar) {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        return new Date(calendar.get(1) - 1900, calendar.get(2), calendar.get(5));
    }

    public static Time calendarizeTo(Time time, Calendar calendar) {
        if (time == null) {
            return null;
        }
        calendar.setTime(time);
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp calendarizeTo(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return null;
        }
        calendar.setTime(timestamp);
        calendar.set(14, (int)((double)timestamp.getNanos() / 1000000.0 + 0.5));
        return new Timestamp(calendar.get(1) - 1900, calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    public static Date calendarizeFrom(Date date, Calendar calendar) {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        int n = (calendar2.get(15) + calendar2.get(16)) / 60000;
        calendar.add(12, n -= (calendar.get(15) + calendar.get(16)) / 60000);
        calendar.add(12, n);
        return new Date(calendar.get(1) - 1900, calendar.get(2), calendar.get(5));
    }

    public static Time calendarizeFrom(Time time, Calendar calendar) {
        if (time == null) {
            return null;
        }
        calendar.setTime(time);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time);
        int n = (calendar2.get(15) + calendar2.get(16)) / 60000;
        calendar.add(12, n -= (calendar.get(15) + calendar.get(16)) / 60000);
        calendar.add(12, n);
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp calendarizeFrom(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return null;
        }
        calendar.setTime(timestamp);
        calendar.set(14, (int)((double)timestamp.getNanos() / 1000000.0 + 0.5));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        int n = (calendar2.get(15) + calendar2.get(16)) / 60000;
        calendar.add(12, n -= (calendar.get(15) + calendar.get(16)) / 60000);
        calendar.add(12, n);
        return new Timestamp(calendar.get(1) - 1900, calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        Object object2;
        PROTOCOL_PREFIX = new String[]{"jdbc:sqlanywhere:"};
        driverInitException = null;
        linkError = null;
        resource_class = class$sybase$jdbc$sqlanywhere$IResource == null ? (class$sybase$jdbc$sqlanywhere$IResource = IDriver.class$("sybase.jdbc.sqlanywhere.IResource")) : class$sybase$jdbc$sqlanywhere$IResource;
        try {
            String string = System.getProperty("asa.location", null);
            if (string != null) {
                if (System.getProperty("java.vm.name").indexOf("64-Bit") != -1) {
                    object2 = IDriver.try_load("dbjdbc11", "dbjdbc11", "asa_location_str", "bin64\\");
                    if (object2 != null) {
                        object2 = IDriver.try_load("dbjdbc11", "dbjdbc11", string, "Bin64\\");
                    }
                    if (object2 != null && (object = (Object)IDriver.try_load("dbjdbc11", "dbjdbc11", string, "ia64\\")) == null) {
                        object2 = null;
                    }
                } else {
                    object2 = IDriver.try_load("dbjdbc11", "dbjdbc11", string, "bin32\\");
                    if (object2 != null) {
                        object2 = IDriver.try_load("dbjdbc11", "dbjdbc11", string, "Bin32\\");
                    }
                }
                if (object2 != null) {
                    string = null;
                }
            }
            if (string == null && (object2 = IDriver.try_load("dbjdbc11", "dbjdbc11", null, null)) != null) {
                linkError = object2;
            }
            try {
                object2 = new IDriver();
                DriverManager.registerDriver((Driver)object2);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                driverInitException = (SQLException)exception;
            }
            driverInitException = new SQLException(IResource.getString("DRIVER_INIT_FAILED", exception.toString() + " : " + exception.getMessage()));
            driverInitException.fillInStackTrace();
        }
        if (driverInitException == null && linkError == null) {
            boolean bl = false;
            object2 = System.getProperty("java.version");
            if (object2 != null) {
                object = new char[8];
                ((String)object2).getChars(0, 3, (char[])object, 0);
                if (object[0] >= '0' && object[0] <= '9' && object[1] == '.' && object[2] >= '0' && object[2] <= '9') {
                    int n = object[0] - 48;
                    int n2 = object[2] - 48;
                    if (n > 1 || n == 1 && n2 >= 6) {
                        bl = true;
                    }
                }
            }
            IDriver.initEnv(3, bl);
        }
    }
}

