/*
 * Decompiled with CFR 0.152.
 */
package sybase.jdbc.sqlanywhere;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sybase.jdbc.sqlanywhere.IColumnsResultSet;
import sybase.jdbc.sqlanywhere.IGetTypeInfoResultSet;
import sybase.jdbc.sqlanywhere.IIResultSet;
import sybase.jdbc.sqlanywhere.INative;
import sybase.jdbc.sqlanywhere.IResource;
import sybase.jdbc.sqlanywhere.IResultSet;

public final class IDatabaseMetaData
extends INative
implements DatabaseMetaData {
    private IDatabaseMetaData(long l) {
        super(l);
        this.nhandle = l;
    }

    public void close() {
    }

    public native boolean dataDefinitionIgnoredInTransactions() throws SQLException;

    public native boolean doesMaxRowSizeIncludeBlobs() throws SQLException;

    public native boolean isCatalogAtStart() throws SQLException;

    public native boolean isReadOnly() throws SQLException;

    public native boolean nullPlusNonNullIsNull() throws SQLException;

    public native boolean nullsAreSortedAtEnd() throws SQLException;

    public native boolean nullsAreSortedAtStart() throws SQLException;

    public native boolean nullsAreSortedHigh() throws SQLException;

    public native boolean nullsAreSortedLow() throws SQLException;

    public native boolean othersUpdatesAreVisible(int var1) throws SQLException;

    public native boolean ownUpdatesAreVisible(int var1) throws SQLException;

    public native boolean storesLowerCaseIdentifiers() throws SQLException;

    public native boolean storesMixedCaseIdentifiers() throws SQLException;

    public native boolean storesUpperCaseIdentifiers() throws SQLException;

    public native boolean supportsAlterTableWithAddColumn() throws SQLException;

    public native boolean supportsAlterTableWithDropColumn() throws SQLException;

    public native boolean supportsANSI92EntryLevelSQL() throws SQLException;

    public native boolean supportsANSI92FullSQL() throws SQLException;

    public native boolean supportsANSI92IntermediateSQL() throws SQLException;

    public native boolean supportsBatchUpdates() throws SQLException;

    public native boolean supportsCatalogsInIndexDefinitions() throws SQLException;

    public native boolean supportsCatalogsInTableDefinitions() throws SQLException;

    public native boolean supportsCatalogsInDataManipulation() throws SQLException;

    public native boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException;

    public native boolean supportsCatalogsInProcedureCalls() throws SQLException;

    public native boolean supportsColumnAliasing() throws SQLException;

    public native boolean supportsCoreSQLGrammar() throws SQLException;

    public native boolean supportsCorrelatedSubqueries() throws SQLException;

    public native boolean supportsDataManipulationTransactionsOnly() throws SQLException;

    public native boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException;

    public native boolean supportsDifferentTableCorrelationNames() throws SQLException;

    public native boolean supportsExtendedSQLGrammar() throws SQLException;

    public native boolean supportsFullOuterJoins() throws SQLException;

    public native boolean supportsExpressionsInOrderBy() throws SQLException;

    public native boolean supportsGroupBy() throws SQLException;

    public native boolean supportsGroupByUnrelated() throws SQLException;

    public native boolean supportsOrderByUnrelated() throws SQLException;

    public native boolean supportsGroupByBeyondSelect() throws SQLException;

    public native boolean supportsIntegrityEnhancementFacility() throws SQLException;

    public native boolean supportsLikeEscapeClause() throws SQLException;

    public native boolean supportsMixedCaseIdentifiers() throws SQLException;

    public native boolean supportsMixedCaseQuotedIdentifiers() throws SQLException;

    public native boolean supportsMultipleResultSets() throws SQLException;

    public native boolean supportsMultipleTransactions() throws SQLException;

    public native boolean supportsOpenCursorsAcrossRollback() throws SQLException;

    public native boolean supportsOpenCursorsAcrossCommit() throws SQLException;

    public native boolean supportsOpenStatementsAcrossCommit() throws SQLException;

    public native boolean supportsOpenStatementsAcrossRollback() throws SQLException;

    public native boolean supportsLimitedOuterJoins() throws SQLException;

    public native boolean supportsOuterJoins() throws SQLException;

    public native boolean supportsPositionedUpdate() throws SQLException;

    public native boolean supportsPositionedDelete() throws SQLException;

    public native boolean supportsSchemasInProcedureCalls() throws SQLException;

    public native boolean supportsSchemasInIndexDefinitions() throws SQLException;

    public native boolean supportsSchemasInTableDefinitions() throws SQLException;

    public native boolean supportsSchemasInDataManipulation() throws SQLException;

    public native boolean supportsSchemasInPrivilegeDefinitions() throws SQLException;

    public native boolean supportsSelectForUpdate() throws SQLException;

    public native boolean supportsStoredProcedures() throws SQLException;

    public native boolean supportsSubqueriesInComparisons() throws SQLException;

    public native boolean supportsSubqueriesInExists() throws SQLException;

    public native boolean supportsSubqueriesInIns() throws SQLException;

    public native boolean supportsSubqueriesInQuantifieds() throws SQLException;

    public native boolean supportsTransactionIsolationLevel(int var1) throws SQLException;

    public native boolean supportsTransactions() throws SQLException;

    public native boolean supportsUnion() throws SQLException;

    public native boolean supportsUnionAll() throws SQLException;

    public native boolean usesLocalFilePerTable() throws SQLException;

    public native boolean usesLocalFiles() throws SQLException;

    public native boolean allProceduresAreCallable() throws SQLException;

    public native boolean allTablesAreSelectable() throws SQLException;

    public native boolean dataDefinitionCausesTransactionCommit() throws SQLException;

    public native boolean deletesAreDetected(int var1) throws SQLException;

    public native boolean updatesAreDetected(int var1) throws SQLException;

    public native boolean insertsAreDetected(int var1) throws SQLException;

    public native boolean othersDeletesAreVisible(int var1) throws SQLException;

    public native boolean othersInsertsAreVisible(int var1) throws SQLException;

    public native boolean ownDeletesAreVisible(int var1) throws SQLException;

    public native boolean ownInsertsAreVisible(int var1) throws SQLException;

    public native boolean storesLowerCaseQuotedIdentifiers() throws SQLException;

    public native boolean storesMixedCaseQuotedIdentifiers() throws SQLException;

    public native boolean storesUpperCaseQuotedIdentifiers() throws SQLException;

    public boolean supportsConvert() throws SQLException {
        return this.supportsConvert(0, 0);
    }

    public native boolean supportsConvert(int var1, int var2) throws SQLException;

    public native boolean supportsMinimumSQLGrammar() throws SQLException;

    public native boolean supportsNonNullableColumns() throws SQLException;

    public native boolean supportsResultSetConcurrency(int var1, int var2) throws SQLException;

    public native boolean supportsResultSetType(int var1) throws SQLException;

    public native boolean supportsTableCorrelationNames() throws SQLException;

    public native int getDefaultTransactionIsolation() throws SQLException;

    public native int getDriverMajorVersion();

    public native int getDriverMinorVersion();

    public native int getMaxBinaryLiteralLength() throws SQLException;

    public native int getMaxCatalogNameLength() throws SQLException;

    public native int getMaxCharLiteralLength() throws SQLException;

    public native int getMaxColumnNameLength() throws SQLException;

    public native int getMaxColumnsInGroupBy() throws SQLException;

    public native int getMaxColumnsInIndex() throws SQLException;

    public native int getMaxColumnsInOrderBy() throws SQLException;

    public native int getMaxColumnsInSelect() throws SQLException;

    public native int getMaxColumnsInTable() throws SQLException;

    public native int getMaxConnections() throws SQLException;

    public native int getMaxCursorNameLength() throws SQLException;

    public native int getMaxIndexLength() throws SQLException;

    public native int getMaxProcedureNameLength() throws SQLException;

    public native int getMaxRowSize() throws SQLException;

    public native int getMaxSchemaNameLength() throws SQLException;

    public native int getMaxStatementLength() throws SQLException;

    public native int getMaxStatements() throws SQLException;

    public native int getMaxTableNameLength() throws SQLException;

    public native int getMaxTablesInSelect() throws SQLException;

    public native int getMaxUserNameLength() throws SQLException;

    public native String getCatalogSeparator() throws SQLException;

    public native String getCatalogTerm() throws SQLException;

    public native String getDatabaseProductName() throws SQLException;

    public native String getDatabaseProductVersion() throws SQLException;

    public String getDriverName() throws SQLException {
        return "SQL Anywhere JDBC Driver";
    }

    public native String getDriverVersion() throws SQLException;

    public native String getExtraNameCharacters() throws SQLException;

    public native String getIdentifierQuoteString() throws SQLException;

    public native ResultSet getNumericFunctionsN() throws SQLException;

    public String getNumericFunctions() throws SQLException {
        ResultSet resultSet = this.getNumericFunctionsN();
        if (resultSet == null) {
            return null;
        }
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public native String getProcedureTerm() throws SQLException;

    public native String getSchemaTerm() throws SQLException;

    public native String getSearchStringEscape() throws SQLException;

    public native String getSQLKeywords() throws SQLException;

    public native ResultSet getStringFunctionsN() throws SQLException;

    public String getStringFunctions() throws SQLException {
        ResultSet resultSet = this.getStringFunctionsN();
        if (resultSet == null) {
            return null;
        }
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public native ResultSet getSystemFunctionsN() throws SQLException;

    public String getSystemFunctions() throws SQLException {
        ResultSet resultSet = this.getSystemFunctionsN();
        if (resultSet == null) {
            return null;
        }
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public native ResultSet getTimeDateFunctionsN() throws SQLException;

    public String getTimeDateFunctions() throws SQLException {
        ResultSet resultSet = this.getTimeDateFunctionsN();
        if (resultSet == null) {
            return null;
        }
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public native String getURL() throws SQLException;

    public native String getUserName() throws SQLException;

    public native Connection getConnection() throws SQLException;

    private ResultSet wrapResultSet(IIResultSet iIResultSet) {
        IResultSet iResultSet = null;
        if (iIResultSet != null) {
            iResultSet = new IResultSet(iIResultSet);
            if (iResultSet.initFailed) {
                iResultSet = null;
            }
        }
        return iResultSet;
    }

    public native IIResultSet RSgetBestRowIdentifier(String var1, String var2, String var3, int var4, boolean var5) throws SQLException;

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        return this.wrapResultSet(this.RSgetBestRowIdentifier(string, string2, string3, n, bl));
    }

    public native IIResultSet RSgetCatalogs() throws SQLException;

    public ResultSet getCatalogs() throws SQLException {
        return this.wrapResultSet(this.RSgetCatalogs());
    }

    public native IIResultSet RSgetColumnPrivileges(String var1, String var2, String var3, String var4) throws SQLException;

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        return this.wrapResultSet(this.RSgetColumnPrivileges(string, string2, string3, string4));
    }

    public native IIResultSet nativeGetColumns(String var1, String var2, String var3, String var4) throws SQLException;

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        IIResultSet iIResultSet = this.nativeGetColumns(string, string2, string3, string4);
        return new IColumnsResultSet(iIResultSet, iIResultSet);
    }

    public native IIResultSet RSgetCrossReference(String var1, String var2, String var3, String var4, String var5, String var6) throws SQLException;

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.wrapResultSet(this.RSgetCrossReference(string, string2, string3, string4, string5, string6));
    }

    public native IIResultSet RSgetExportedKeys(String var1, String var2, String var3) throws SQLException;

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.wrapResultSet(this.RSgetExportedKeys(string, string2, string3));
    }

    public native IIResultSet RSgetImportedKeys(String var1, String var2, String var3) throws SQLException;

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.wrapResultSet(this.RSgetImportedKeys(string, string2, string3));
    }

    public native IIResultSet RSgetIndexInfo(String var1, String var2, String var3, boolean var4, boolean var5) throws SQLException;

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        return this.wrapResultSet(this.RSgetIndexInfo(string, string2, string3, bl, bl2));
    }

    public native IIResultSet RSgetPrimaryKeys(String var1, String var2, String var3) throws SQLException;

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        return this.wrapResultSet(this.RSgetPrimaryKeys(string, string2, string3));
    }

    public native IIResultSet RSgetProcedureColumns(String var1, String var2, String var3, String var4) throws SQLException;

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.wrapResultSet(this.RSgetProcedureColumns(string, string2, string3, string4));
    }

    public native IIResultSet RSgetProcedures(String var1, String var2, String var3) throws SQLException;

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        return this.wrapResultSet(this.RSgetProcedures(string, string2, string3));
    }

    public native IIResultSet RSgetSchemas() throws SQLException;

    public ResultSet getSchemas() throws SQLException {
        return this.wrapResultSet(this.RSgetSchemas());
    }

    public native IIResultSet RSgetTablePrivileges(String var1, String var2, String var3) throws SQLException;

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        return this.wrapResultSet(this.RSgetTablePrivileges(string, string2, string3));
    }

    public native IIResultSet getTablesN(String var1, String var2, String var3, String var4) throws SQLException;

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4;
        if (stringArray == null) {
            string4 = null;
        } else {
            int n = stringArray.length;
            string4 = stringArray[0];
            for (int i = 1; i < n; ++i) {
                string4 = string4 + "," + stringArray[i];
            }
        }
        return this.wrapResultSet(this.getTablesN(string, string2, string3, string4));
    }

    public native IIResultSet RSgetTableTypes() throws SQLException;

    public ResultSet getTableTypes() throws SQLException {
        return this.wrapResultSet(this.RSgetTableTypes());
    }

    public native IIResultSet RSgetTypeInfo() throws SQLException;

    public ResultSet getTypeInfo() throws SQLException {
        IIResultSet iIResultSet = this.RSgetTypeInfo();
        return new IGetTypeInfoResultSet(iIResultSet, iIResultSet);
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        Connection connection = this.getConnection();
        String string4 = this.getDriverName();
        if (!(string4.toUpperCase().startsWith("DBODBC") || string4.startsWith("SQL Anywhere") || string4.startsWith("Adaptive Server Anywhere"))) {
            throw new SQLException(IResource.getString("NYI"));
        }
        int n = 2000;
        String string5 = "(CASE d.domain_name WHEN 'smallint' THEN 'java.lang.Short' WHEN 'integer' THEN 'java.lang.Integer' WHEN 'numeric' THEN 'java.math.BigDecimal' WHEN 'float' THEN 'java.lang.Float' WHEN 'double' THEN 'java.lang.Double' WHEN 'date' THEN 'java.sql.Date' WHEN 'binary' THEN 'java.lang.Byte' WHEN 'long binary' THEN 'java.sql.Blob' WHEN 'timestamp' THEN 'java.sql.Timestamp' WHEN 'time' THEN 'java.sql.Time' WHEN 'tinyint' THEN 'java.lang.Byte' WHEN 'bigint' THEN 'java.lang.Long' WHEN 'unsigned int' THEN 'java.lang.Integer' WHEN 'unsigned smallint' THEN 'java.lang.Short' WHEN 'unsigned bigint' THEN 'java.lang.Long' WHEN 'bit' THEN 'java.lang.Byte' WHEN 'decimal' THEN 'java.math.BigDecimal' WHEN 'varbinary' THEN 'byte[]' WHEN 'java.lang.Object' THEN t.type_name ELSE 'java.lang.String' END ) as CLASS_NAME, ";
        String string6 = "SELECT CAST(NULL AS char(128)) as TYPE_CAT, CAST(u.user_name AS char(128)) as TYPE_SCHEM, CAST(t.type_name AS char(128)) as TYPE_NAME, " + string5 + "CAST(" + n + " AS int) as DATA_TYPE," + "CAST(NULL AS char(128)) AS REMARKS," + "CAST(NULL AS smallint) AS BASE_TYPE " + "FROM " + "SYS.SYSUSERTYPE t, " + "SYS.SYSDOMAIN d, " + "SYS.SYSUSERPERMS u " + "WHERE " + "t.domain_id=d.domain_id AND " + "t.creator=u.user_id AND " + "t.type_name LIKE ? AND " + "u.user_name LIKE ?";
        if (string != null && !string.equals(connection.getCatalog())) {
            throw new SQLException(IResource.getString("CATALOGS"));
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null) {
            string3 = "%";
        }
        if (nArray != null) {
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 2000) continue;
                bl = false;
                break;
            }
            if (bl) {
                string6 = string6 + " AND 1 = 2";
            }
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string6);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        return resultSet;
    }

    public native IIResultSet RSgetVersionColumns(String var1, String var2, String var3) throws SQLException;

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return this.wrapResultSet(this.RSgetVersionColumns(string, string2, string3));
    }

    public native void nFree();

    public int getDatabaseMajorVersion() throws SQLException {
        int n;
        String string = this.getDatabaseProductVersion();
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) < '0' || string.charAt(n) > '9') continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return 0;
        }
        for (n = n2; n < string.length(); ++n) {
            if (string.charAt(n) >= '0' && string.charAt(n) <= '9') continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            n3 = string.length();
        }
        return new Integer(string.substring(n2, n3));
    }

    public int getDatabaseMinorVersion() throws SQLException {
        int n;
        String string = this.getDatabaseProductVersion();
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) < '0' || string.charAt(n) > '9') continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return 0;
        }
        for (n = n2; n < string.length(); ++n) {
            if (string.charAt(n) >= '0' && string.charAt(n) <= '9') continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            return 0;
        }
        n2 = -1;
        for (n = n3; n < string.length(); ++n) {
            if (string.charAt(n) < '0' || string.charAt(n) > '9') continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return 0;
        }
        n3 = -1;
        for (n = n2; n < string.length(); ++n) {
            if (string.charAt(n) >= '0' && string.charAt(n) <= '9') continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            n3 = string.length();
        }
        return new Integer(string.substring(n2, n3));
    }

    public boolean supportsSavepoints() {
        return true;
    }

    public boolean supportsNamedParameters() {
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        return false;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    public ResultSet getSuperTypes(String object, String object2, String string) throws SQLException {
        Object object3;
        Object object4;
        Connection connection = this.getConnection();
        String string2 = this.getDriverName();
        if (!(string2.startsWith("DBODBC") || string2.startsWith("SQL Anywhere") || string2.startsWith("Adaptive Server Anywhere"))) {
            throw new SQLException(IResource.getString("NYI"));
        }
        if (string != null) {
            int n;
            object4 = null;
            object3 = null;
            int n2 = string.indexOf(46, 0);
            if (n2 != -1) {
                object4 = string.substring(0, n2);
            }
            if ((n = string.indexOf(46, n2 + 1)) != -1) {
                object3 = string.substring(n2 + 1, n);
            }
            if (object4 != null && object3 != null) {
                object = object4;
                object2 = object3;
                string = string.substring(n + 1);
            } else if (object4 != null) {
                object = null;
                object2 = object4;
                string = string.substring(n2 + 1);
            }
        }
        if (object != null && !((String)object).equals(connection.getCatalog())) {
            throw new SQLException(IResource.getString("CATALOGS"));
        }
        if (object2 == null) {
            object2 = "%";
        }
        if (string == null) {
            string = "%";
        }
        object4 = connection.prepareStatement("    select db_name() as TYPE_CAT,\t\t u.user_name as TYPE_SCHEM,\t\t ut.type_name as TYPE_NAME,\t\t db_name() as SUPERTYPE_CAT,\t\t 'SYS' as SUPERTYPE_SCHEM,\t\t d.domain_name as SUPERTYPE_NAME    FROM\t\t SYS.SYSUSERTYPE ut,\t\t SYS.SYSUSERPERMS u,\t\t SYS.SYSDOMAIN d,    WHERE\t\t ut.type_name LIKE ? AND\t\t ut.creator = u.user_id AND\t\t u.user_name LIKE ? AND\t\t d.domain_id = ut.domain_id");
        object4.setString(1, string);
        object4.setString(2, (String)object2);
        object3 = object4.executeQuery();
        return object3;
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        boolean bl = this.supportsOpenCursorsAcrossCommit();
        if (bl && n == 1) {
            return true;
        }
        return !bl && n == 2;
    }

    public int getResultSetHoldability() throws SQLException {
        boolean bl = this.supportsOpenCursorsAcrossCommit();
        if (bl) {
            return 1;
        }
        return 2;
    }

    public int getJDBCMajorVersion() {
        return 3;
    }

    public int getJDBCMinorVersion() {
        return 0;
    }

    public int getSQLStateType() {
        return 2;
    }

    public boolean locatorsUpdateCopy() {
        return true;
    }

    public boolean supportsStatementPooling() {
        return false;
    }
}

