/*
 * Decompiled with CFR 0.152.
 */
package sybase.jdbc.sqlanywhere;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import sybase.jdbc.sqlanywhere.IBlobBinaryStream;
import sybase.jdbc.sqlanywhere.IIResultSet;
import sybase.jdbc.sqlanywhere.IResource;

public class IBlob
implements Blob {
    private byte[] curbuf;
    private long curpos = 1L;
    private long blob_len;
    private IIResultSet rs;
    private int cidx;

    public IBlob(int n, IIResultSet iIResultSet, long l) {
        this.rs = iIResultSet;
        this.cidx = n;
        if (l == -3L) {
            try {
                this.curbuf = iIResultSet.getBytes(this.cidx);
            }
            catch (SQLException sQLException) {
                this.curbuf = null;
            }
        } else {
            this.curbuf = null;
        }
        this.blob_len = this.curbuf != null ? (long)this.curbuf.length : l;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new IBlobBinaryStream(this);
    }

    private byte[] getFixedBytes(long l, int n) throws SQLException {
        if (l == 1L && this.blob_len == 0L) {
            return new byte[0];
        }
        if (l > this.blob_len) {
            return null;
        }
        long l2 = l + (long)n - 1L;
        if (l2 > this.blob_len) {
            l2 = this.blob_len;
        }
        n = (int)(l2 - l + 1L);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.curbuf[(int)(l - 1L + (long)i)];
        }
        return byArray;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            throw new SQLException(IResource.getString("BLOB_GET_BYTES_ARGUMENT"));
        }
        if (this.curbuf != null) {
            return this.getFixedBytes(l, n);
        }
        if (this.blob_len <= -2L) {
            this.blob_len = -1L;
        }
        if (l == 1L && this.blob_len == 0L) {
            return new byte[0];
        }
        if (l != this.curpos) {
            return null;
        }
        byte[] byArray = this.rs.getBlobBytes(this.cidx, n);
        if (byArray != null) {
            this.curpos += (long)byArray.length;
        }
        return byArray;
    }

    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray = this.getBytes(this.curpos, n);
        if (byArray != null) {
            this.curpos += (long)byArray.length;
        }
        return byArray;
    }

    public byte getNextByte() throws IOException {
        try {
            byte[] byArray = this.getBytes(this.curpos, 1);
            if (byArray != null) {
                return byArray[0];
            }
            return -1;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public long length() throws SQLException {
        return this.blob_len;
    }

    public long position(Blob blob, long l) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public long position(byte[] byArray, long l) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void truncate(long l) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }
}

